<?php
/*--------------------------------------------------------------
   Service.php 2021-08-01
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Data;

use DateTimeInterface;
use Gambio\Admin\Modules\Statistics\App\Data\Data\Repository;
use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Serial;
use Gambio\Admin\Modules\Statistics\Services\StatisticsDataService;

class Service implements StatisticsDataService
{
    /**
     * @var Repository
     */
    private $repository;
    
    /**
     * @var Factory
     */
    private $factory;
    
    
    /**
     * Constructor.
     */
    public function __construct(Repository $repository, Factory $factory)
    {
        $this->repository = $repository;
        $this->factory    = $factory;
    }
    
    
    /**
     * @inheritDoc
     */
    public function getOrdersByTimespan(DateTimeInterface $start, DateTimeInterface $end): Serial
    {
        return $this->repository->getOrdersByTimespan($this->factory->useTimespan()->createTimespan($start, $end));
    }
    
    
    /**
     * @inheritDoc
     */
    public function getConversionRatesByTimespan(DateTimeInterface $start, DateTimeInterface $end): Serial
    {
        return $this->repository->getConversionRatesByTimespan($this->factory->useTimespan()
                                                                   ->createTimespan($start, $end));
    }
    
    
    /**
     * @inheritDoc
     */
    public function getSalesByTimespan(DateTimeInterface $start, DateTimeInterface $end): Serial
    {
        return $this->repository->getSalesByTimespan($this->factory->useTimespan()->createTimespan($start, $end));
    }
    
    
    /**
     * @inheritDoc
     */
    public function getVisitorsByTimespan(DateTimeInterface $start, DateTimeInterface $end): Serial
    {
        return $this->repository->getVisitorsByTimespan($this->factory->useTimespan()->createTimespan($start, $end));
    }
}